{*
* 2017 Coccinet
*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* DISCLAIMER
*
*  @author Coccinet
*  @copyright  2017 Coccinet
*}

{if $ElavonOrder}
<div class="panel" id="manage_Elavonpayments">
  <div class="panel-heading">
    <i class="icon-money"></i>
    {l s='Elavon Payments Transaction Management'  mod='Elavonpaymentshpp'}
  </div>

  <form id="formElavonPayments"  method="post" action="{$current_index|escape:'htmlall':'UTF-8'}&amp;vieworder&amp;id_order={$order->id|escape:'htmlall':'UTF-8'}&amp;token={$smarty.get.token|escape:'html':'UTF-8'}#formAddPaymentPanel">
    <div class="table-responsive">
      {if $transaction_statut =="KO"}
        <p class="alert alert-danger">{$transaction_return|escape:'htmlall':'UTF-8'}</p>
        {else if $transaction_statut =="OK"}
        <p class="alert alert-success">{$transaction_return|escape:'htmlall':'UTF-8'}</p>
      {/if}
      <table class="table">
        <thead>
          <tr>
            <th><span class="title_box ">{l s='Amount' mod='Elavonpaymentshpp'}</span></th>
            <th><span class="title_box ">{l s='Currency' mod='Elavonpaymentshpp'}</span></th>
            <th><span class="title_box ">{l s='Action' mod='Elavonpaymentshpp'}</span></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><input type="text" name="Elavonpayments_amount" value="{$original_amount|escape:'htmlall':'UTF-8'}" class="form-control fixed-width-md pull-left" /> </td>
            <td>{$ElavonOrder['Elavonpayments_original_currency']|escape:'htmlall':'UTF-8'}</td>
            <td class="actions">
              <button class="btn btn-primary" type="submit" name="Elavonpayments_transaction" value="settle">
                {l s='Settle' mod='Elavonpaymentshpp'}
              </button>
              <button class="btn btn-primary" type="submit" name="Elavonpayments_transaction" value="void">
                {l s='Void' mod='Elavonpaymentshpp'}
              </button>
              <button class="btn btn-primary" type="submit" name="Elavonpayments_transaction" value="rebate">
                {l s='Rebate' mod='Elavonpaymentshpp'}
              </button>
            </td>
          </tr>
          <tr>
            <td colspan="3"><em>{l s='You can Settle or Rebate a transaction for any amount up to 115% or the original value.' mod='Elavonpaymentshpp'}(Maximum : <strong>{$max_authorized|escape:'htmlall':'UTF-8'}{$ElavonOrder['Elavonpayments_original_currency']|escape:'htmlall':'UTF-8'}</strong>)</em></td>
          </tr>
        </tbody>
      </table>
    </div>
  </form>
</div>
<div class="panel" id="history_Elavonpayments">
  <div class="panel-heading">
    <i class="icon-money"></i>
    {l s='Elavon Payments Transaction Management History' mod='Elavonpaymentshpp'}
  </div>

  <table class="table">
    <thead>
      <tr>
        <th><span class="title_box ">{l s='Date' mod='Elavonpaymentshpp'}</span></th>
        <th><span class="title_box ">{l s='Action' mod='Elavonpaymentshpp'}</span></th>
        <th><span class="title_box ">{l s='Amount' mod='Elavonpaymentshpp'}</span></th>
        <th><span class="title_box ">{l s='Result' mod='Elavonpaymentshpp'}</span></th>
      </tr>
    </thead>
    <tbody>
      {foreach from=$transaction_history item=row key=key}
      <tr class="{if $row['success']}success{else}danger{/if}">
        <td>{dateFormat date=$row['date_add'] full=true}</td>
        <td>{$row['action']|escape:'htmlall':'UTF-8'}</td>
        <td>{$row['amount']|escape:'htmlall':'UTF-8'}{$ElavonOrder['Elavonpayments_original_currency']|escape:'htmlall':'UTF-8'}</td>
        <td>{$row['result']|escape:'htmlall':'UTF-8'}</td>
      </tr>
      {/foreach}
    </tbody>
  </table>
</div>
<script type="text/javascript">
  $(document).ready(function() {
  $('#messages').prepend(
    '<div class="message-item">'+
    '<div class="message-avatar">'+
      '<div class="avatar-md">'+
        '<i class="icon-user icon-2x"></i>'+
      '</div>'+
    '</div>'+
    '<div class="message-body">'+
      '<span class="message-date">&nbsp;<i class="icon-calendar"></i>'+
        "{$message_date|escape:'htmlall':'UTF-8'}-"+
      '</span>'+
      '<h4 class="message-item-heading">'+
        "{$message_customer|escape:'htmlall':'UTF-8'}"+
        '<span class="badge badge-info">Private</span>'+
     ' </h4>'+
      '<p class="message-item-text" id="omi-message-text">'+
      '</p>'+
    '</div>'+
  '</div>');


  $('#omi-message-text').html("{$message_text|escape:'javascript':'UTF-8'}");


});
</script>
{/if}
