<?php
/**

 * NOTICE OF LICENSE

 *

 * This file is licenced under the Software License Agreement.

 * With the purchase or the installation of the software in your application

 * you accept the licence agreement.

 *

 * You must not modify, adapt or create derivative works of this source code

 *

 *  @author    Coccinet

 *  @copyright 2017 Coccinet

 *  @license   LICENSE.txt

 */

class ElavonPaymentsHppValidationModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        echo "<p style='color:#777;font-weight: bold;font-size:13px;'>".$this->module->l('Please wait while you are redirected to the confirmation payment page ...', 'validation')."</p>";
        die();
    }

    public function postProcess()
    {

        $results = $this->module->getResults($_POST);
        $id_cart             = explode('-', $results['ORDER_ID']);
        $order_id = $results['ORDER_ID']; //toDo
        $cart                 = new Cart($id_cart[0]);
        $currency = $this->context->currency;

        //test basic informations before submit
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
            $this->module->getRedirection('step1');
            exit;
        }

        // create and check user
        $customer = new Customer($cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            $this->module->getRedirection('error');
            exit;
        }
        //get the current order total amount and currency
        $this->context->currency->id = $cart->id_currency;
        $total = (float)$cart->getOrderTotal(true, Cart::BOTH);

        // # code to check RP API reply
        $hash_response = ElavonPaymentsTools::getHashResponse($results['TIMESTAMP'], $results['MERCHANT_ID'], $results['ORDER_ID'], $results['RESULT'], $results['MESSAGE'], $results['PASREF'], $results['AUTHCODE'], $this->module->getConfig()->getSharedSecret());
        // set the current statut of payement ERROR
        $statut_payment = Configuration::get('PS_OS_ERROR');
        $extra_vars = array();
        //write RP API result to log
        if ($this->module->getConfig()->getLogsEnabled()) {
            $this->module->writeLogs($results);
        }

        if ($hash_response === $results['SHA1HASH']) {
            switch ($results['RESULT']) {
                case '00':
                    $extra_vars['transaction_id'] = $results['ORDER_ID'];
                    $logsLight = $this->module->getLogs($results, 'light');
                    $orderStatePending = new OrderState(Configuration::get('ELAVONPAYMENTS_PENDING_STATUS'));
                    if ($orderStatePending->id && !$this->module->getConfig()->getAutoSettle()) {
                        $statut_payment = Configuration::get('ELAVONPAYMENTS_PENDING_STATUS');
                    } else {
                        $statut_payment = Configuration::get('PS_OS_PAYMENT');
                    }
            //get the payment text defined on backoffice
                    $payment_text_array = $this->module->getConfig()->getPaymentText();

            //1.7 only
                    if (!$payment_text_array[$this->context->language->id]) {
                        $payment_text = "Pay By Credit or Debit Card";
                    } else {
                        $payment_text = $payment_text_array[$this->context->language->id];
                    }
                    $this->module->validateOrder($cart->id, $statut_payment, $total, $payment_text, $logsLight, $extra_vars, (int)$cart->id_currency, false, $customer->secure_key);
                    $ElavonOrder = new ElavonPaymentsOrders();
                    $ElavonOrder->addOrder(Order::getOrderByCartId($cart->id), $results['PASREF'], $results['AUTHCODE'], $results['ORDER_ID'], $cart->getOrderTotal(true, Cart::BOTH), $currency->iso_code);

                    if ($this->module->getConfig()->getCardStorageEnabled()) {
                        if (isset($results['REALWALLET_CHOSEN']) && isset($results['PAYER_SETUP'])) {
                            if ($results['REALWALLET_CHOSEN'] == 1 && $results['PAYER_SETUP'] == "00") {
                                $payerref = new ElavonPaymentsCards($this->module);
                                $payerref->addPayer($customer->id, $results['SAVED_PAYER_REF'], Order::getOrderByCartId($cart->id));
                            }
                        }
                    }

                    echo "<p style='color:#777;font-weight: bold;font-size:13px;'>".$this->module->l('Please wait while you are redirected to the confirmation payment page ...', 'validation')."</p>";
                    $this->module->getRedirection('confirmation', $cart, $customer);
                    die();
                default:
                    $this->module->saveFailure($results['RESULT'], $results['MESSAGE'], $cart->id, $order_id);
                    $this->module->getRedirection('error', null, null, $results['RESULT']);
                    break;
            }
        } else {
            $this->module->saveFailure($results['RESULT'], 'HASH ERROR', $cart->id, $order_id);
            $this->module->getRedirection('error', $cart, $customer, 'HASH');
        }
    }
}
