<?php
/**

 * NOTICE OF LICENSE

 *

 * This file is licenced under the Software License Agreement.

 * With the purchase or the installation of the software in your application

 * you accept the licence agreement.

 *

 * You must not modify, adapt or create derivative works of this source code

 *

 *    @author        Coccinet

 *    @copyright 2017 Coccinet

 *    @license     LICENSE.txt

 */

if (!defined('_PS_VERSION_')) {
        exit;
}

/**
 * Module configuration
 */
class ElavonPaymentsConfig
{
    private $_defaults = array(
            'ELAVONPAYMENTS_PRODUCTION'  => 0,
            'ELAVONPAYMENTS_ENABLE_LOGS'  => 0,
            'ELAVONPAYMENTS_MERCHANT_ID'  => '',
            'ELAVONPAYMENTS_SHARED_SECRET'  => '',
            'ELAVONPAYMENTS_REBATE_PASSWORD'  => '',
            'ELAVONPAYMENTS_SUBACCOUNT' => '',
            'ELAVONPAYMENTS_URL_LIVE' => 'https://pay.elavonpaymentgateway.com/pay',
            'ELAVONPAYMENTS_URL_SANDBOX'  => 'https://pay.sandbox.elavonpaymentgateway.com/pay',
            'ELAVONPAYMENTS_AUTO_SETTLE'  => '1',
            'ELAVONPAYMENTS_HPP_LANG' => 'customer',
            'ELAVONPAYMENTS_HPP_LANG_ISO' => '',
            'ELAVONPAYMENTS_IFRAME' =>'0',
            'ELAVONPAYMENTS_IFRAME_TYPE'  =>'embed',
            'ELAVONPAYMENTS_CARD_STORAGE' => '0',
            'ELAVONPAYMENTS_OFFER_SAVE_CARD'  => '0',
            'ELAVONPAYMENTS_PENDING_STATUS'  => '2',
    );

    private function setMultiLanguagePaymentText()
    {
        $payment_text = array();
        $languages = Language::getLanguages(false);
        foreach ($languages as $lang) {
            $payment_text[$lang['id_lang']] = 'Pay by Credit or Debit Card';
        }
        return $payment_text;
    }

    private function _get($name)
    {
        $value = Configuration::get($name);
        if (is_null($value)) {
            $value = false;
        }
        if ($value === false) {
            $value = $this->_defaults[$name];
        }
        return $value;
    }

    private function _getMultilang($name)
    {
        $vals = array();
        $languages = Language::getLanguages(false);
        foreach ($languages as $lang) {
            if (Configuration::get($name, $lang['id_lang'])) {
                $vals[$lang['id_lang']] = Configuration::get($name, $lang['id_lang']);
            }
        }
        $value = $vals;
        if (!count($value)) {
            $value = $this->setMultiLanguagePaymentText();
        }
        return $value;
    }

    public function getProdEnabled()
    {
        return $this->_get('ELAVONPAYMENTS_PRODUCTION');
    }
    public function getLogsEnabled()
    {
        return $this->_get('ELAVONPAYMENTS_ENABLE_LOGS');
    }

    public function getMerchantId()
    {
        return $this->_get('ELAVONPAYMENTS_MERCHANT_ID');
    }

    public function getSharedSecret()
    {
        require_once(dirname(__FILE__) ."/encode.php");
        $e = new CryptData();
        return $e->decrypter($this->_get('ELAVONPAYMENTS_SHARED_SECRET'));
    }

    public function getRebatePassword()
    {
        require_once(dirname(__FILE__) ."/encode.php");
        $e = new CryptData();
        return $e->decrypter($this->_get('ELAVONPAYMENTS_REBATE_PASSWORD'));
    }

    public function getSubaccount()
    {
        return $this->_get('ELAVONPAYMENTS_SUBACCOUNT');
    }

    public function getUrlSandbox()
    {
        return $this->_get('ELAVONPAYMENTS_URL_SANDBOX');
    }

    public function getUrlLive()
    {
        return $this->_get('ELAVONPAYMENTS_URL_LIVE');
    }
    public function getPaymentText()
    {
        return $this->_getMultiLang('ELAVONPAYMENTS_PAYMENT_TEXT');
    }
    public function getHPPLang()
    {
        return $this->_get('ELAVONPAYMENTS_HPP_LANG');
    }
    public function getHPPLangIso()
    {
        return $this->_get('ELAVONPAYMENTS_HPP_LANG_ISO');
    }
    public function getAutoSettle()
    {
        return $this->_get('ELAVONPAYMENTS_AUTO_SETTLE');
    }
    public function getIframeEnabled()
    {
        return $this->_get('ELAVONPAYMENTS_IFRAME');
    }
    public function getIframeType()
    {
        return $this->_get('ELAVONPAYMENTS_IFRAME_TYPE');
    }
    public function getCardStorageEnabled()
    {
        return $this->_get('ELAVONPAYMENTS_CARD_STORAGE');
    }
    public function getOfferSaveCard()
    {
        return $this->_get('ELAVONPAYMENTS_OFFER_SAVE_CARD');
    }
    public function getDelayedStatus()
    {
        return $this->_get('ELAVONPAYMENTS_PENDING_STATUS');
    }

    public function getUrlFinal()
    {
        if ($this->getProdEnabled()) {
            return $this->getUrlLive();
        } else {
            return $this->getUrlSandbox();
        }
    }

    public function getUrlApiFinal()
    {
        if ($this->getProdEnabled()) {
            return "https://api.elavonpaymentgateway.com/remote";
        } else {
            return "https://api.sandbox.elavonpaymentgateway.com/remote";
        }
    }

    public function displayAsLightbox()
    {
        if ($this->getIframeEnabled() && $this->getIframeType() =="lightbox") {
            return true;
        }
        return false;
    }
}
