<?php

error_reporting(-1);
ini_set('display_errors', 'On');

  $db = init_database();

  try {

    $json = file_get_contents("php://input");
    $order = json_decode($json);
    
    $sql = "INSERT INTO orders (  event, 
                                  outlet, 
                                  reference, 
                                  email, 
                                  currency, 
                                  amount ) VALUES (  :event, 
                                                          :outlet, 
                                                          :ref, 
                                                          :email, 
                                                          :currency, 
                                                          :amount );";      
    $stmt = $db->prepare($sql);

    $stmt->bindParam(":event", $order->eventName);
    $stmt->bindParam(":outlet", $order->order->outletId);
    $stmt->bindParam(":ref", $order->order->reference);
    $stmt->bindParam(":email", $order->order->emailAddress);
    $stmt->bindParam(":currency", $order->order->amount->currencyCode);
    $stmt->bindParam(":amount", number_format($order->order->amount->value / 100, 2));
    $stmt->execute();

    echo '{"success": true}';

    $db = null;      

  }
  catch(PDOException $e) 
  {
    
    $sql = "INSERT INTO orders() VALUES();";
    $stmt = $db->prepare($sql);
    $stmt->execute();

    echo '{"error":{"text":'. $e->getMessage() .'}}';

    $db = null;      

  }		    

  die();

  function init_database() {

    $dbhost="localhost";
    $dbuser="robin";
    $dbpass="ariana79dbrobin";
    $dbname="ngo";
    $dbh = new PDO("mysql:host=$dbhost;dbname=$dbname;", $dbuser, $dbpass);
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    return $dbh;

  }

?>