<?php

  header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
  header("Pragma: no-cache"); // HTTP 1.0.
  header("Expires: 0"); // Proxies.

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "DTD/xhtml1-strict.dtd">

<html>

	<head>

		<title>N-Genius OpenPay</title>

		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>		
		<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
		<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>		

    <script>
    
      $(document).ready(function() {

        $("#opIdForm").submit(function( event ) {
          event.preventDefault();
          $("#opIdSubmit").attr("disabled", true);

          $("#opFindVendor").hide();
          $("#opOrderDetails").fadeIn();
          
        });

      });
    
    </script>
    
  </head>
  
  <body style="height: 100%;">

    <div class="container-fluid">

      <div class="row align-items-center justify-content-center">

        <div class="col-xs-12">

          <div class="card" style="width: 28rem;">
            <img class="card-img-top" src="logo-network.svg" alt="Card image cap" style="padding: 4rem; background-color: #F4F6F9;">
            <div class="card-body" id="opFindVendor" style="padding: 2rem 2rem 2rem 2rem;">
              <h5 class="card-title">Who are you paying?</h5>
              <p class="card-text">Please paste or key in the OpenPay ID of the vendor you wish to pay below.</p>
              <form id="opIdForm">
                <div class="form-group">
                  <label for="opId">OpenPay ID</label>
                  <input type="number " class="form-control" id="opId" aria-describedby="opIdHelp" placeholder="Enter OpenPay ID">
                  <small id="opIdHelp" class="form-text text-muted">This will have been provided to you by your vendor.</small>
                </div>
                <button id="opIdSubmit" type="submit" class="btn btn-primary float-right">
                  Find vendor
                </button>
              </form>
            </div>

            <div class="card-body" id="opOrderDetails" style="display:none; padding: 2rem 2rem 2rem 2rem;">
              <h5 class="card-title">You are paying #vendor_name#</h5>
              <p class="card-text">Is that right? If you're not sure, please <a href="#" class="card-link">go back</a> and check the vendor's OpenPay ID you provided.</p>
              <form id="opIdForm">
                <div class="form-group">
                  <label for="opReference">Vendor reference</label>
                  <input type="text" class="form-control" id="opReference" placeholder="123456">
                  <small id="opReferenceHelp" class="form-text text-muted">You should have received this from your vendor.</small>
                </div>
                <div class="form-group">
                  <label for="opEmail">Email address</label>
                  <input type="email" class="form-control" id="opEmail" placeholder="Enter your email address">
                </div>
                <div class="form-group">
                  <label for="opAmount">Payment amount</label>
                  <div class="input-group mb-3">
                    <div class="input-group-prepend">
                      <span class="input-group-text">AED</span>
                    </div>
                    <input type="number" class="form-control" id="opAmount" aria-label="Payment amount (AED)">
                  </div>
                </div>
                <button id="opIdSubmit" type="submit" class="btn btn-primary float-right">
                  Make payment
                </button>
              </form>
            </div>
          </div>
        
        </div>

      </div>
    
    </div>
    
  </body>
  
</html>