<?php

  // UAT URLS
  $idserv_url = "https://identity.ngenius-payments.com/auth/realms/NetworkInternational/protocol/openid-connect/token";
  $txnserv_url = "https://api-gateway.ngenius-payments.com";

  $apikey = "ZjQyYjI3ZTUtZmJiZS00ODQzLTg2OTYtODk1NzI2ZjhkODgxOjVhMzNmZjYxLWNmODEtNDc4Ni05MWJjLTYzMzdkNjEyMGQ1YQ==";       // ENTER YOUR API KEY HERE
  $outlet = "94223ab2-5bb9-467f-a6a7-fc4b22c435af";                                                                       // ENTER YOUR OUTLET REFERENCE HERE

  $token = null;
  $cardpay_url = null;
  $state = null;

  $cnp3ds_url = null;
  $acsurl = null;
  $acspareq = null;
  $acsmd = null;
  $acsterm = null;

  if (isset($_POST['operation'])) {
    
    // GET ACCESS TOKEN (STEP 1)
    if ($_POST['operation'] == "getToken") {

      $apikey = $_POST['apikey']; 

      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, $idserv_url);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: Basic ".$apikey, "Content-Type: application/x-www-form-urlencoded"));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS,  http_build_query(array('grant_type' => 'client_credentials')));

      $output = json_decode(curl_exec($ch));
      $token = $output->access_token;

      curl_close ($ch);        
      
    }
    
    // CREATE ORDER (STEP 2)
    if ($_POST['operation'] == "createOrder") {
      
      $token = $_POST['token']; 
      $outlet = $_POST['outlet']; 
      $action = $_POST['action']; 
      $currency = $_POST['currency']; 
      $amount = $_POST['amount']; 

      
      $postData = new StdClass();
      $postData->action = $action;
      $postData->amount = new StdClass();
      $postData->amount->currencyCode = $currency;
      $postData->amount->value = $amount;
      
      $json = json_encode($postData);
      
      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, $txnserv_url."/transactions/outlets/".$outlet."/orders");
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: Bearer ".$token, "Content-Type: application/vnd.ni-payment.v2+json", "Accept: application/vnd.ni-payment.v2+json"));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
      
      $output = json_decode(curl_exec($ch));
      $cardpay_url = $output->_embedded->payment[0]->_links->{'payment:card'}->href;

      curl_close ($ch);              
      
    }
    
    // SEND CARD DATA (STEP 3)
    if ($_POST['operation'] == "sendCardData") {

      $token = $_POST['token']; 
      $cardpay_url = $_POST['cardpay_url']; 
      $pan = $_POST['pan']; 
      $expiry = $_POST['expiry']; 
      $cvv = $_POST['cvv']; 
      $name = $_POST['cardholderName'];       

      $postData = new StdClass();      
      $postData->pan = $pan;
      $postData->expiry = $expiry;
      $postData->cvv = $cvv;
      $postData->cardholderName = $name;

      $json = json_encode($postData);
      
      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, $cardpay_url);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: Bearer ".$token, "Content-Type: application/vnd.ni-payment.v2+json", "Accept: application/vnd.ni-payment.v2+json"));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
      curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
      
      $output = json_decode(curl_exec($ch));
      
      $state = $output->state;
      
      if ($state == "AWAIT_3DS") {
        
        $cnp3ds_url = $output->_links->{'cnp:3ds'}->href;
        $acsurl = $output->{'3ds'}->acsUrl;
        $acspareq = $output->{'3ds'}->acsPaReq;
        $acsmd = $output->{'3ds'}->acsMd;
        $acsterm = "https://pullingteeth.co.uk/network/example_code/handle_3ds.php";                                                    // ENTER YOUR POST-3DS SCRIPT URL HERE (MAY BE $SELF)
        
      }
      
      curl_close ($ch);                    
      
    }

    // EXECUTE 3DS DATA PUSH (STEP 4)
    if ($_POST['operation'] == "sendPaRes") {
    
      $pares = $_POST['pares']; 
      $cnp3ds_url = $_POST['cnp3ds_url']; 

      $postData = new StdClass();
      $postData->PaRes = $pares;   

      $json = json_encode($postData);
      
      $ch = curl_init();

      curl_setopt($ch, CURLOPT_URL, $cnp3ds_url);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: Bearer ".$token, "Content-Type: application/vnd.ni-payment.v2+json", "Accept: application/vnd.ni-payment.v2+json"));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);		
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

      $output = json_decode(curl_exec($ch));

      $state = $output->state;
      
    }
    
  }


?>


<html>
  
  <head>
    
    <title>Example - Direct (with 3DS)</title>
    
  </head>
  
  <body>
    
    <h4>
      1. Get Access Token
    </h4>
    
    <form action="direct_example.php" method="POST">
      
      <input type="hidden" name="operation" value="getToken">
      
      API Key: <input type="text" name="apikey" value="<?php echo($apikey); ?>">
      
      <input type="submit">
      
    </form>

    <hr>
      
    <?php if($token != null) : ?>
    
    <h4>
      
      2. Create Order
      
    </h4>
    
    <form action="direct_example.php" method="POST">
      
      <input type="hidden" name="operation" value="createOrder">
      
      Access Token: <input type="text" name="token" value="<?php echo($token); ?>"><br>
      Outlet Ref: <input type="text" name="outlet" value="<?php echo($outlet); ?>"><br>
      Action: <input type="text" name="action" value="SALE"><br>
      Currency: <input type="text" name="currency" value="AED"><br>
      Amount: <input type="text" name="amount" value="100"><br>
            
      <br>
      
      <input type="submit">
      
    </form>
    
    <hr>

    <?php endif; ?>
    
    <?php if($cardpay_url != null) : ?>
    
    <h4>
      
      3. Send Card Data
      
    </h4>
    
    <form action="direct_example.php" method="POST">
      
      <input type="hidden" name="operation" value="sendCardData">

      Access Token: <input type="text" name="token" value="<?php echo($token); ?>"><br>
      Card Payment URL: <input type="text" name="cardpay_url" value="<?php echo($cardpay_url); ?>"><br>
      
      PAN: <input type="text" name="pan" value=""><br>
      Expiry (YYYY-MM): <input type="text" name="expiry" value=""><br>
      CVV: <input type="text" name="cvv" value=""><br>
      Name: <input type="text" name="cardholderName" value=""><br>
            
      <br>
      
      <input type="submit">
      
    </form>
    
    <hr>    

    <?php endif; ?>

    <?php if($state != null) : ?>

    <br><b>State: <?php echo($state); ?></b>
    
    <?php endif; ?>

    <?php if($state == "AWAIT_3DS") : ?>

    <br>
    
    <h4>
      
      4. Optional - Process 3DS data
      
    </h4>    
    
    <iframe src="<?php echo("handle_3ds.php?acsUrl=".$acsurl."&TermUrl=".$acsterm."&PaReq=".urlencode($acspareq)."&MD=".$acsmd); ?>">
      
    </iframe>
    
    <br><br>
    
    <form action="direct_example.php" method="POST">
      
      <input type="hidden" name="operation" value="sendPaRes">

      PaRes (copy from above): <input type="text" name="pares" value=""><br>
      Push PaRes URL: <input type="text" name="cnp3ds_url" value="<?php echo($cnp3ds_url); ?>"><br>
            
      <br>
      
      <input type="submit">
      
    </form>    
    
    <?php endif; ?>
    
    
  </body>
  
</html>