<html>

	<head>

		<title>N-Genius Online Test Simulator</title>

		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>		
		<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
		<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>		

		<script>

			$(document).ready(function(){

				$("#order_create :input").prop("disabled", true);					
				$("#order_manage :input").prop("disabled", true);					

				$("#panel_1").css("background-color", "#ffffff");
				$("#panel_2").css("background-color", "#ffffff");
				$("#panel_2").css("background-color", "#ffffff");
				
				setPanel(1);
				
				$("#get_bearer_token").click( function() { getBearerToken(); } );
				$("#clear_bearer_token").click( function() { $("#bearer_token").val(""); $("#bearer_token").change(); } );
				$("#create_order").click( function() { createOrder(); } );
				$("#get_order").click( function() { getOrder(); } );

				$("#bearer_token").change( function() { 
				
					if ( $(this).val() != null && $(this).val() != '') 
					{ 
					
						$("#clear_bearer_token").attr('disabled', false); 
						$("#order_create :input").prop("disabled", false);					
						$("#get_order").attr('disabled', false); 
						setPanel(2);
						
					} 
					else 
					{ 
					
						$("#clear_bearer_token").attr('disabled', true); 
						$("#order_create :input").prop("disabled", true);					
						$("#get_order").attr('disabled', true); 
						
					}
				
				} );
				
				$("#order_reference").change( function() {
				
					if ( $(this).val() != null && $(this).val() != '' )
					{
					
						$("#order_manage :input").prop("disabled", false);											
					
					}
					else
					{
					
						$("#order_manage :input").prop("disabled", true);					

					}
				
				} );
				
				function setPanel(num) {
				
					$("#panel_1").css("background-color", "#ffffff");
					$("#panel_2").css("background-color", "#ffffff");
					$("#panel_2").css("background-color", "#ffffff");
					
					if (num == 1) { $("#panel_1").css("background-color", "#eeffee"); }
					if (num == 2) { $("#panel_2").css("background-color", "#eeffee"); }
					if (num == 3) { $("#panel_3").css("background-color", "#eeffee"); }
				
				}
				
				function getBearerToken_old() {
				
					$("#get_bearer_token").attr('disabled', true);
				
					var keycloak_url = $("#keycloakUrl").val();
					
					var cid = $("#client_id").val();
					var uname = $("#username").val();
					var pwd = $("#password").val();
					var gt = $("#grant_type").val();
					
					$.post('token.php', { action: 'gettoken' },
					function(data, status){
						
						var message = JSON.parse(data);
						console.log(message);
						
						$("#bearer_token").val(message.access_token);
						$("#bearer_token").change();
						
						$("#get_bearer_token").attr('disabled', false);

					});
				
				}

				function getBearerToken() {
				
					$("#get_bearer_token").attr('disabled', true);
				
					var endpoint = $("#keycloakUrl").val();
					var apikey = $("#apikey").val();
					
					$.post('token.php', { action: 'gettoken', 'endpoint': endpoint, 'apikey': apikey },
					function(data, status){
						
						var message = JSON.parse(data);
						console.log(message);
						
						$("#bearer_token").val(message.access_token);
						$("#bearer_token").change();
						
						$("#get_bearer_token").attr('disabled', false);

					});
				
				}
				
				function createOrder() {

					$("#order_create :input").prop("disabled", true);					
				
					var pToken = $("#bearer_token").val();
					var pOutlet = $("#outlet_id").val();
					var pEndpoint = $("#txnServiceUrl").val() + "/transactions/outlets/" + pOutlet + "/orders";
					
					var ord_act = $("#order_action").val();
					var ord_lang = $("#order_language").val();
					var ord_curr = $("#order_currency").val();
					var ord_amount = $("#order_amount").val();
					var ord_desc = $("#order_description").val();
					var ord_redirect = $("#order_redirect").val();
				
					var sendData = {
					
						action: ord_act,
						amount: { currencyCode: ord_curr, value: parseInt(ord_amount) },
						language: ord_lang,
						description: ord_desc,
						merchantAttributes: { redirectUrl: ord_redirect }
					
					};
					var pPayload = JSON.stringify(sendData);
					
					$.post('token.php', { action: 'createorder', 'endpoint': pEndpoint, 'token': pToken, 'payload': pPayload },
					function(data, status) {

						$("#order_create :input").prop("disabled", false);					
					
						parseOrderResponse(data);
						
						$("#order_reference").change();
						setPanel(3);						
						
					});
										
				}
				
				function parseOrderResponse(data) {
				
					var message = JSON.parse(data);
					console.log(message);
					
					var paypage_link = "";
					var links = message._links;
					if (links.hasOwnProperty("payment")) {
						paypage_link = message._links.payment.href;
						$("#go_to_paymentpage").click( function() { window.open(paypage_link); } );
						$("#go_to_paymentpage").prop("disabled", false);
					}
					var order_ref = message.reference;
					var payment_ref = message._embedded.payment[0]._id.substring(12);
					var order_state = message._embedded.payment[0].state;

					$("#order_paymentpage").val(paypage_link);
					$("#order_reference").val(order_ref);
					$("#order_state").val(order_state);
					$("#payment_reference").val(payment_ref);
					
				}
				
				function getOrder() {

					var pToken = $("#bearer_token").val();
					var pOutlet = $("#outlet_id").val();
					var pOrder = $("#order_reference").val();
					var pEndpoint = $("#txnServiceUrl").val() + "/transactions/outlets/" + pOutlet + "/orders/" + pOrder;

					$("#get_order").attr('disabled', true); 
					
					$.post('token.php', { action: 'getorder', 'endpoint': pEndpoint, 'token': pToken },
					function(data, status) {
					
						parseOrderResponse(data);
						$("#get_order").attr('disabled', false); 
						
					});
				
				}

			});

		</script>

	</head>

	<body>
	
		<div class="container">
		
			<div class="row">
			
				<div class="col-sm" id="panel_1" style="padding-bottom:25px;">
				
					<h3 style="text-align:center; margin-top:20px;">1. Identify Yourself</h3>
					<p style="text-align:center; margin-bottom:20px;">Select your environment and generate/input a bearer token to get started</p>
					
					<hr>

					<div class="form-group">
						<label for="environment">Environment:</label>
						<select class="form-control" id="environment">
							<option>UAT Environment</option>
							<option>Sandbox (Dev)</option>
							<option selected>Custom</option>
						</select>
					</div>

					<div class="form-group">				
						<label for="keycloakUrl">KeyCloak Service:</label>
						<input type="text" class="form-control" id="keycloakUrl" placeholder="Enter KeyCloak service location" value="https://identity.uat.ngenius-payments.com/auth/realms/ni-uat/protocol/openid-connect/token">
					</div>
					
					<div class="form-group">				
						<label for="txnServiceUrl">Transaction Service:</label>
						<input type="text" class="form-control" id="txnServiceUrl" placeholder="Enter Transaction service location" value="https://api-gateway.uat.ngenius-payments.com">
					</div>

					<hr>

					<div class="form-group">				
						<label for="apikey">API Key:</label>
						<input type="text" class="form-control" id="apikey" placeholder="[apikey]" value="NjFiZWY3NTEtMDNhMi00NjU4LThhMmYtYmE2ZmRiMTEwYTFkOmE2ZDI1NDgwLTkyMzYtNDMyNi1hNDI2LWJmNmEzYmRlZmNhOA==">
					</div>
					
					<hr>
					
					<button type="button" class="btn btn-primary btn-block" id="get_bearer_token">Get Bearer Token</button>

				</div>

				<div class="col-sm" id="panel_2" style="padding-bottom:25px;">

					<h3 style="text-align:center; margin-top:20px;">2. Create Order</h3>
					<p style="text-align:center; margin-bottom:20px;">You'll need a bearer token and a valid outlet reference for this step.</p>
					
					<hr>

					<div class="form-group">				
						<label for="bearer_token">Bearer Token:</label>
						<input type="text" class="form-control" id="bearer_token" placeholder="[empty]" value="">
					</div>

					<button type="button" class="btn btn-secondary btn-block" id="clear_bearer_token" disabled>Clear Token</button>
					
					<hr>
					
					<form id="order_create">

						<div class="form-group">				
							<label for="outlet_id">Outlet ID:</label>
							<input type="text" class="form-control" id="outlet_id" placeholder="[outlet_id]" value="5708a3b8-ee25-487d-8438-b0c9b6b31392">
						</div>
						
						<hr>

						<div class="form-group">
							<label for="order_action">Payment action:</label>
							<select class="form-control" id="order_action">
								<option value="AUTH" selected>Auth only (AUTH)</option>
								<option value="SALE">Sale (SALE)</option>
							</select>
						</div>
						
						<div class="form-group">
							<label for="order_language">Language:</label>
							<select class="form-control" id="order_language">
								<option value="en" selected>English (en)</option>
								<option value="ar">Arabic (ar)</option>
							</select>
						</div>

						<div class="form-row">
						
							<div class="form-group col-sm-6">
								<label for="order_currency">Currency:</label>
								<select class="form-control" id="order_currency">
									<option value="AED" selected>AED</option>
									<option value="USD">USD</option>
									<option value="EUR">EUR</option>
									<option value="GBP">GBP</option>
								</select>
							</div>
								
							<div class="form-group col-sm-6">				
								<label for="order_amount">Amount <small>(minor units *)</small>:</label>
								<input type="number" class="form-control" id="order_amount" placeholder="[amount.value]" value="1000">
								<small style="float:right;">* i.e. 1000 = 10.00 AED</small>
							</div>
								
						</div>

						<div class="form-group">				
							<label for="order_description">Description:</label>
							<input type="text" class="form-control" id="order_description" placeholder="[description]" value="1 x Big Widget">
						</div>
						
						<div class="form-group">				
							<label for="order_redirect">Redirect URL:</label>
							<input type="text" class="form-control" id="order_redirect" placeholder="[merchantAttributes.redirectUrl]" value="http://178.62.24.29/network/">
						</div>
						
						<hr>

						<button type="button" class="btn btn-primary btn-block" id="create_order">Create New Order</button>

					</form>
					
				</div>

				<div class="col-sm" id="panel_3" style="padding-bottom:25px;">

					<h3 style="text-align:center; margin-top:20px;">3. Manage Order</h3>
					<p style="text-align:center; margin-bottom:20px;">To access these functions, you'll need a valid order reference.</p>
					
					<hr>

					<div class="form-group">				
						<label for="order_paymentpage">Payment Page:</label> 
						<input type="text" class="form-control" id="order_paymentpage" placeholder="[empty]" value="">
					</div>			
					
					<form id="order_manage">

						<div class="form-group">				
							<label for="order_reference">Order Reference:</label>
							<input type="text" class="form-control" id="order_reference" placeholder="[empty]" value="">
						</div>

						<button type="button" class="btn btn-success btn-block" id="go_to_paymentpage">Visit Payment Page</button>
						
						<hr>

						<button type="button" class="btn btn-primary btn-block" id="get_order">Get Order Status</button>

						<hr>
						
						<div class="form-group">				
							<label for="order_state">Order State:</label>
							<input type="text" class="form-control" id="order_state" placeholder="[empty]" value="">
						</div>

						<div class="form-group">				
							<label for="payment_reference">Payment Reference:</label>
							<input type="text" class="form-control" id="payment_reference" placeholder="[empty]" value="">
						</div>
						
					</form>
					
				</div>

			</div>

		</div>
		
	</body>
	
</html>